/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscLockManager;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;

public class HSCRecoveryPlugin {
    private CIMOMHandle mHandle = null;
    private String[] mMethodNames = null;
    private static final short RECOVERY_STATE = 251;
    private static final short NO_CONNECTION_STATE = 254;
    private static final short CTA_VERIFY_STATE = 15;
    private static final short VER_MISMATCH_STATE = 250;
    private static final String MOF_STATE = "State";
    private static final String MOF_NAME = "Name";
    private static final String NAME_SEPARATOR = "*";
    public static final String ENTER_TIME_NAME = "ENTER_TIME";
    public static final String CEC_OBJECT_PATH = "CEC_OBJECT_PATH";

    public HSCRecoveryPlugin(CIMOMHandle cIMOMHandle, String[] stringArray) {
        this.mHandle = cIMOMHandle;
        this.mMethodNames = stringArray;
    }

    public void setCIMOMHandle(CIMOMHandle cIMOMHandle) {
        this.mHandle = cIMOMHandle;
    }

    /*
     * Unable to fully structure code
     */
    public static CIMObjectPath getCECObjectPath(CIMOMHandle var0, CIMObjectPath var1_1) throws CIMException {
        block7: {
            System.out.println("in op: " + var1_1);
            var2_2 = CimomWrapper.getInstance(var0, var1_1, var0.getClass(var1_1, false), false);
            var3_3 = var2_2.getClassName();
            System.out.println("clsName: " + var3_3);
            var4_4 = null;
            var4_4 = var3_3.equalsIgnoreCase("IBMHSC_LparProfile") != false ? (String)var2_2.getProperty("PartitionName").getValue().getValue() : (var3_3.equalsIgnoreCase("IBMHSC_SystemProfile") != false ? (String)var2_2.getProperty("ComputerSystemName").getValue().getValue() : (String)var2_2.getProperty("Name").getValue().getValue());
            System.out.println("objName: " + var4_4);
            var5_5 = var4_4.lastIndexOf("*");
            if (var5_5 == -1) {
                throw new CIMException("internal error, not a valid cec object or its child");
            }
            var6_6 = var4_4.indexOf("*");
            if (var5_5 != var6_6) ** GOTO lbl18
            if (!var3_3.equals("IBMHSC_ComputerSystem")) break block7;
            return var1_1;
lbl-1000:
            // 1 sources

            {
                var4_4 = var4_4.substring(var6_6 + 1);
                var6_6 = var4_4.indexOf("*");
                var5_5 = var4_4.lastIndexOf("*");
lbl18:
                // 2 sources

                ** while (var6_6 != var5_5)
            }
lbl19:
            // 1 sources

            System.out.println("objName: " + var4_4);
        }
        var7_7 = new CIMObjectPath("IBMHSC_ComputerSystem", var1_1.getNameSpace());
        var8_8 = CimomWrapper.enumInstances(var0, var7_7, false, new CIMClass("IBMHSC_ComputerSystem"), false);
        var9_9 = 0;
        while (var9_9 < var8_8.size()) {
            var10_10 = (CIMInstance)var8_8.elementAt(var9_9);
            var11_11 = (String)var10_10.getProperty("Name").getValue().getValue();
            System.out.println("name: " + var11_11);
            if (var11_11.equals(var4_4)) {
                var12_12 = new CIMObjectPath("IBMHSC_ComputerSystem", var10_10.getKeyValuePairs());
                var12_12.setNameSpace(var1_1.getNameSpace());
                return var12_12;
            }
            ++var9_9;
        }
        throw new CIMException("Cannot find cec object " + var4_4);
    }

    protected String getObjName(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals(MOF_NAME)) {
                return (String)cIMProperty.getValue().getValue();
            }
            ++n;
        }
        return null;
    }

    private UnsignedInt8 getCECState(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMValue cIMValue = this.mHandle.getProperty(cIMObjectPath, MOF_STATE);
        return (UnsignedInt8)cIMValue.getValue();
    }

    private String getCecName(CIMObjectPath cIMObjectPath) throws CIMException {
        System.out.println("cecop: " + cIMObjectPath);
        System.out.println("MOF_ANME: Name");
        CIMValue cIMValue = this.mHandle.getProperty(cIMObjectPath, MOF_NAME);
        System.out.println("after get the cim value: " + cIMValue);
        return (String)cIMValue.getValue();
    }

    private NVRAM getNVRAMForCec(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = this.getCecName(cIMObjectPath);
        System.out.println("bef get nvram cecName: " + string);
        return (NVRAM)NVRAM.NVRAM_TABLE.get(string);
    }

    private void checkBadNVRAM(CIMObjectPath cIMObjectPath, long l) throws CIMException {
        String string = this.getCecName(cIMObjectPath);
        NVRAM nVRAM = this.getNVRAMForCec(cIMObjectPath);
        if (nVRAM == null) {
            return;
        }
        long l2 = nVRAM.getNvramErrorTime();
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        if (!hscCecLock.isWriteLock()) {
            return;
        }
        System.out.println("nvram error time: " + l2);
        if (l2 > l) {
            this.handleNVRAMError(this.mHandle, cIMObjectPath, this.getClass().getName());
        } else {
            System.out.println("error time smaller than enterTime ");
        }
    }

    private void handleNVRAMError(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(251));
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        System.out.println("-----in synchronzed zoon: " + string);
        cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
        System.out.println("got cec instance");
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty(MOF_STATE).getValue().getValue();
        short s = unsignedInt8.shortValue();
        System.out.println("cec state is: " + s);
        if (s == 251 || s == 250 || s == 254 || s == 15) {
            return;
        }
        System.out.println("change cec state");
        cIMInstance2 = cIMInstance.filterProperties(null, true, true);
        cIMInstance2.setProperty(MOF_STATE, cIMValue);
        CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance2);
        System.out.println("-----out synchronzed zoon: " + string);
        System.out.println("send out indication");
        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
    }

    private boolean validateMethodName(String string) {
        if (this.mMethodNames == null || this.mMethodNames.length < 1) {
            return true;
        }
        int n = 0;
        while (n < this.mMethodNames.length) {
            if (string.equals(this.mMethodNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean preprocess(CIMObjectPath cIMObjectPath, String string, Vector vector, Hashtable hashtable) throws CIMException {
        if (string != null && !this.validateMethodName(string)) {
            return true;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)hashtable.get(CEC_OBJECT_PATH);
        return this.getCECState(cIMObjectPath2).shortValue() != 251;
    }

    public void reqpostprocess(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2, Hashtable hashtable) throws CIMException {
        System.out.println("in reqpostprocess, method name is: " + string);
        Long l = (Long)hashtable.get(ENTER_TIME_NAME);
        if (l == 0L) {
            System.out.println("no nvram error");
            return;
        }
        if (string != null && !this.validateMethodName(string)) {
            return;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)hashtable.get(CEC_OBJECT_PATH);
        if (cIMObjectPath2 == null) {
            try {
                cIMObjectPath2 = HSCRecoveryPlugin.getCECObjectPath(this.mHandle, cIMObjectPath);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }
        this.checkBadNVRAM(cIMObjectPath2, l);
    }
}

